// Header File
// Created 27/12/2003; 21:52:55
//Affichage indicateurs de position et gestion...

#define FLECHE_HAUT					0
#define FLECHE_BAS					1
#define FLECHE_GAUCHE				2
#define FLECHE_DROITE				3
#define FLECHE_STEP2				4

//Affiche indicateur
void ShowIndicators (void)
{
	unsigned char sprite=0;
	short x,y;
	
	BOOL pos0,pos1,pos2,pos3;
	
	//TI92+ ou V200
	if (CALCULATOR)
	{
		//Si mode graphique=0 (Scrolling vertical seulement)
		if (!GRAPHIC_MODE)
		{	
			//------------------
			//INDICATEURS BILLES
			//------------------
			//Parcours Billes
			for (int i=0;i<nbrBille;i++)
			{
				//Bille dans zone?
				pos0=(Bille [i]->ypos+BILLE_SIZEY2)<yScroll;
				pos1=Bille [i]->ypos>(yScroll+127);
				
				//Si bille en dehors de l'cran
				if (pos0 || pos1)
				{
					//Dplacement vers le haut
					if (Bille [i]->ydir==-1)
						sprite=FLECHE_HAUT;
					//Dplacement vers le bas
					else
						sprite=FLECHE_BAS;
											
					//Zone affichage sprite
					if (pos0)
						y=yScroll;
					else
						y=yScroll+127-8;	
					
					//Dessine flches
					DrawFleche (Bille [i]->xpos,y,8,SPRITE_FLECHE [sprite],SPRITE_FLECHE [sprite],ScreenBuffer);
				}
			}
			
			//-------------------
			//INDICATEURS RACKETS
			//-------------------	
			//Parcours rackets
			for (int i=0;i<nbrRacket;i++)
			{
				//Racket dans zone?
				pos0=(Racket [i]->ypos+Racket [i]->size_y2)<yScroll;
				pos1=Racket [i]->ypos>(yScroll+127);
				
				//Si Racket en dehors de l'cran
				if (pos0 || pos1)
				{
					//Vers le Haut
					if (pos0)	{
						sprite=FLECHE_HAUT;
						y=yScroll;}
					//Vers le Bas
					else {
						sprite=FLECHE_BAS;
						y=yScroll+127-8;}
					
					//Dessine flches
					DrawFleche (Racket [i]->xpos+(Racket [i]->size_x2/2),y,8,SPRITE_FLECHE [sprite],SPRITE_FLECHE [sprite],ScreenBuffer);
				}
			}
		}
	}
	
	//TI89
	else
	{
		//Si mode graphique=0 (Scrolling vertical seulement)
		if (!GRAPHIC_MODE)
		{	
			//------------------
			//INDICATEURS BILLES
			//------------------
			//Parcours Billes
			for (int i=0;i<nbrBille;i++)
			{
				//Bille dans zone? Suivant x
				pos0=(Bille [i]->xpos+BILLE_SIZEX2)<xScroll;
				pos1=Bille [i]->xpos>(xScroll+159);
				
				//Bille dans zone? Suivant y
				pos2=(Bille [i]->ypos+BILLE_SIZEY2)<yScroll;
				pos3=Bille [i]->ypos>(yScroll+99);
				
				//Si bille en dehors de l'cran suivant x
				if (pos0 || pos1 || pos2 || pos3)
				{
					//Coordonnes par dfaut
					x=Bille [i]->xpos+(BILLE_SIZEX2/2);
					y=Bille [i]->ypos+(BILLE_SIZEY2/2);
					
					//Suivant y
					if (pos2 || pos3)
					{
						//Dplacement vers le haut
						if (Bille [i]->ydir==-1)
							sprite=FLECHE_HAUT;
						//Dplacement vers le bas
						else
							sprite=FLECHE_BAS;
											
						//Zone affichage sprite
						if (pos2)
							y=yScroll;
						else
							y=yScroll+99-8;	
					}
					
					//Suivant x
					if (pos0 || pos1)
					{
						//Dplacement vers la gauche
						if (Bille [i]->xdir==-1)
							sprite=FLECHE_GAUCHE;
						//Dplacement vers la droite
						else
							sprite=FLECHE_DROITE;
											
						//Zone affichage sprite
						if (pos0)
							x=xScroll;
						else
							x=xScroll+159-8;	
					}
					
					//Dessine flches
					DrawFleche (x,y,8,SPRITE_FLECHE [sprite],SPRITE_FLECHE [sprite],ScreenBuffer);
				}
			}
			
			//-------------------
			//INDICATEURS RACKETS
			//-------------------	
			//Parcours rackets
			for (int i=0;i<nbrRacket;i++)
			{
				//Racket dans zone? Suivant x
				pos0=(Racket [i]->xpos+Racket [i]->size_x2)<xScroll;
				pos1=Racket [i]->xpos>(xScroll+159);
				
				//Racket dans zone? Suivant y
				pos2=(Racket [i]->ypos+Racket [i]->size_y2)<yScroll;
				pos3=Racket [i]->ypos>(yScroll+99);
				
				//Si Racket en dehors de l'cran
				if (pos0 || pos1 || pos2 || pos3)
				{
					//Coordonnes par dfaut
					x=Racket [i]->xpos+(Racket [i]->size_x2/2);
					y=Racket [i]->ypos+(Racket [i]->size_y2/2);
					
					//Suivant y
					if (pos2 || pos3)
					{
						if (pos2)	{
							sprite=FLECHE_HAUT;
							y=yScroll;}
						//Vers le Bas
						else {
							sprite=FLECHE_BAS;
							y=yScroll+99-8;}
					}
						
					//Suivant x
					if (pos0 || pos1)
					{
						if (pos0)	{
							sprite=FLECHE_GAUCHE;
							x=xScroll;}
						//Vers le Bas
						else {
							sprite=FLECHE_DROITE;
							x=xScroll+159-8;}
					}
					
					//Dessine flches
					DrawFleche (x,y,8,SPRITE_FLECHE [sprite],SPRITE_FLECHE [sprite],ScreenBuffer);
				}
			}
		}
	}
}